/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.User;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import io.fusionauth.domain.event.ObjectIdentifiable;
import io.fusionauth.domain.jwt.RefreshToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;

public class JWTRefreshTokenRevokeEvent
extends BaseEvent
implements Buildable<JWTRefreshTokenRevokeEvent>,
ObjectIdentifiable {
    public final User user;
    public UUID applicationId;
    public Map<UUID, Integer> applicationTimeToLiveInSeconds = new TreeMap<UUID, Integer>();
    public RefreshToken refreshToken;
    public UUID userId;

    public JWTRefreshTokenRevokeEvent(EventInfo info, User user, UUID applicationId, int timeToLiveInSeconds) {
        super(info);
        this.applicationId = applicationId;
        this.applicationTimeToLiveInSeconds.put(applicationId, timeToLiveInSeconds);
        this.user = user != null ? new User(user).secure().sort() : null;
        this.userId = user == null ? null : user.id;
    }

    public JWTRefreshTokenRevokeEvent(EventInfo info, User user, Map<UUID, Integer> applicationTimeToLiveInSeconds) {
        super(info);
        this.applicationTimeToLiveInSeconds.putAll(applicationTimeToLiveInSeconds);
        this.user = user != null ? new User(user).secure().sort() : null;
        this.userId = user == null ? null : user.id;
    }

    @JacksonConstructor
    public JWTRefreshTokenRevokeEvent() {
        this.user = null;
    }

    public List<UUID> applicationIds() {
        return new ArrayList<UUID>(this.applicationTimeToLiveInSeconds.keySet());
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JWTRefreshTokenRevokeEvent that = (JWTRefreshTokenRevokeEvent)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.applicationTimeToLiveInSeconds, that.applicationTimeToLiveInSeconds) && Objects.equals(this.user, that.user) && Objects.equals(this.userId, that.userId);
    }

    @Override
    public UUID getLinkedObjectId() {
        return this.userId;
    }

    @Override
    public void setLinkedObjectId(UUID linkedObjectId) {
    }

    @Override
    public EventType getType() {
        return EventType.JWTRefreshTokenRevoke;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.applicationTimeToLiveInSeconds, this.user, this.userId);
    }
}

