/*
 * Copyright (c) 2022, FusionAuth, All Rights Reserved
 */
package io.fusionauth.domain.webauthn;

/**
 * Used to communicate whether and how authenticator attestation should be delivered to the Relying Party
 *
 * @author Spencer Witt
 */
public enum AttestationConveyancePreference {
  /**
   * The Relying Party is not interested in authenticator attestation. The authenticator will select this as the default if no value is provided
   */
  none,

  /**
   * The Relying Party wants to receive verifiable attestation statements, but allows the client to replace portions of the attestation statement
   * in order to protect the identity of the user
   */
  indirect,

  /**
   * The Relying Party wants to receive the attestation statement as it was generated by the authenticator
   */
  direct,

  /**
   * The Relying Party wants to receive an attestation statement that may contain uniquely identifying information. This is intended for use in
   * controlled deployments, such as an enterprise environment, where the Relying Party wishes to tie registrations to specific authenticators
   */
  enterprise
}
