/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.User;
import io.fusionauth.domain.event.BaseUserEvent;
import io.fusionauth.domain.event.EventType;
import java.util.Objects;
import java.util.UUID;

public class UserIdentityUpdateEvent
extends BaseUserEvent
implements Buildable<UserIdentityUpdateEvent> {
    public final String loginIdType;
    public final String newLoginId;
    public final String previousLoginId;

    public UserIdentityUpdateEvent(EventInfo info, String previousLoginId, String newLoginId, String loginIdType, User user) {
        super(info, user);
        this.previousLoginId = previousLoginId;
        this.newLoginId = newLoginId;
        this.loginIdType = loginIdType;
    }

    @JacksonConstructor
    private UserIdentityUpdateEvent() {
        this.previousLoginId = null;
        this.newLoginId = null;
        this.loginIdType = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserIdentityUpdateEvent that = (UserIdentityUpdateEvent)o;
        return Objects.equals(this.previousLoginId, that.previousLoginId) && Objects.equals(this.newLoginId, that.newLoginId) && Objects.equals(this.loginIdType, that.loginIdType);
    }

    @Override
    public UUID getLinkedObjectId() {
        return this.user != null ? super.getLinkedObjectId() : null;
    }

    @Override
    public EventType getType() {
        return EventType.UserIdentityUpdate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.previousLoginId, this.newLoginId, this.loginIdType);
    }
}

