/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.connector;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.connector.BaseConnectorConfiguration;
import io.fusionauth.domain.connector.ConnectorType;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class LDAPConnectorConfiguration
extends BaseConnectorConfiguration
implements Buildable<LDAPConnectorConfiguration> {
    public URI authenticationURL;
    public String baseStructure;
    public int connectTimeout;
    public String identifyingAttribute;
    public LambdaConfiguration lambdaConfiguration = new LambdaConfiguration();
    public String loginIdAttribute;
    public int readTimeout;
    public List<String> requestedAttributes = new ArrayList<String>();
    public LDAPSecurityMethod securityMethod;
    public String systemAccountDN;
    public String systemAccountPassword;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LDAPConnectorConfiguration)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LDAPConnectorConfiguration that = (LDAPConnectorConfiguration)o;
        return this.connectTimeout == that.connectTimeout && this.readTimeout == that.readTimeout && Objects.equals(this.authenticationURL, that.authenticationURL) && Objects.equals(this.baseStructure, that.baseStructure) && Objects.equals(this.loginIdAttribute, that.loginIdAttribute) && Objects.equals(this.identifyingAttribute, that.identifyingAttribute) && Objects.equals(this.lambdaConfiguration, that.lambdaConfiguration) && Objects.equals(this.requestedAttributes, that.requestedAttributes) && this.securityMethod == that.securityMethod && Objects.equals(this.systemAccountDN, that.systemAccountDN) && Objects.equals(this.systemAccountPassword, that.systemAccountPassword);
    }

    @Override
    public ConnectorType getType() {
        return ConnectorType.LDAP;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.authenticationURL, this.baseStructure, this.connectTimeout, this.loginIdAttribute, this.identifyingAttribute, this.lambdaConfiguration, this.readTimeout, this.requestedAttributes, this.securityMethod, this.systemAccountDN, this.systemAccountPassword});
    }

    @Override
    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class LambdaConfiguration {
        public UUID reconcileId;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LambdaConfiguration)) {
                return false;
            }
            LambdaConfiguration that = (LambdaConfiguration)o;
            return Objects.equals(this.reconcileId, that.reconcileId);
        }

        public int hashCode() {
            return Objects.hash(this.reconcileId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static enum LDAPSecurityMethod {
        None,
        LDAPS,
        StartTLS;

    }
}

