/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.api.user;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.api.BaseEventRequest;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class ActionRequest
extends BaseEventRequest {
    public ActionData action;
    public boolean broadcast;

    @JacksonConstructor
    public ActionRequest() {
    }

    public ActionRequest(ActionData action, boolean broadcast) {
        this.action = action;
        this.broadcast = broadcast;
    }

    public ActionRequest(EventInfo eventInfo, ActionData action, boolean broadcast) {
        super(eventInfo);
        this.action = action;
        this.broadcast = broadcast;
    }

    public void normalize() {
        if (this.action != null) {
            this.action.normalize();
        }
    }

    public static class ActionData
    implements Buildable<ActionData> {
        public UUID actioneeUserId;
        public UUID actionerUserId;
        public List<UUID> applicationIds;
        public String comment;
        public boolean emailUser;
        public ZonedDateTime expiry;
        public boolean notifyUser;
        public String option;
        public UUID reasonId;
        public UUID userActionId;

        public ActionData() {
        }

        public ActionData(UUID userActionId, UUID actioneeUserId, UUID actionerUserId, String comment, ZonedDateTime expiry, boolean notifyUser, boolean emailUser, String option, UUID reasonId, UUID ... applicationIds) {
            this.userActionId = userActionId;
            this.actioneeUserId = actioneeUserId;
            this.actionerUserId = actionerUserId;
            this.comment = comment;
            this.expiry = expiry;
            this.notifyUser = notifyUser;
            this.emailUser = emailUser;
            this.option = option;
            this.reasonId = reasonId;
            this.normalize();
            Collections.addAll(this.applicationIds, applicationIds);
        }

        public void normalize() {
            this.comment = Normalizer.trim(this.comment);
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList<UUID>();
            } else {
                Normalizer.removeEmpty(this.applicationIds);
            }
        }
    }
}

